/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.dom.Application;
import org.autoplot.scriptconsole.ExitExceptionHandler;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.python.core.PyJavaInstance;

public class PythonScriptContext
extends PyJavaInstance {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");
    PythonScriptContext instance;
    private ApplicationModel model = null;
    private Application dom = null;
    private AutoplotUI view = null;

    public PythonScriptContext(ApplicationModel model) {
        this.model = model;
        this.dom = model.getDocumentModel();
    }

    public PythonScriptContext(AutoplotUI app) {
        this.view = app;
        this.dom = app.getDocumentModel();
        this.model = this.dom.getController().getApplicationModel();
    }

    private void setUpHeadlessExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "runtime exception: " + e, e);
                if (e instanceof InconvertibleUnitsException) {
                    return;
                }
                PythonScriptContext.this.model.getExceptionHandler().handleUncaught(e);
            }
        });
    }

    private void maybeInitModel() {
        if (this.model == null) {
            this.model = new ApplicationModel();
            this.model.setExceptionHandler(new ExitExceptionHandler());
            this.setUpHeadlessExceptionHandler();
            this.model.addDasPeersToAppAndWait();
            this.dom = this.model.getDocumentModel();
        }
        if (this.view != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (!this.view.isVisible()) {
                    this.view.setVisible(true);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!PythonScriptContext.this.view.isVisible()) {
                            PythonScriptContext.this.view.setVisible(true);
                        }
                    }
                });
            }
        }
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z, String renderType) {
        this.maybeInitModel();
        if (z.rank() == 1) {
            ArrayDataSet yds = ArrayDataSet.copy((QDataSet)y);
            yds.putProperty("RENDER_TYPE", (Object)renderType);
            yds.putProperty("DEPEND_0", (Object)x);
            yds.putProperty("PLANE_0", (Object)z);
            this.model.setDataSet(chNum, label, (QDataSet)yds);
        } else {
            ArrayDataSet zds = ArrayDataSet.copy((QDataSet)z);
            zds.putProperty("RENDER_TYPE", (Object)renderType);
            if (x != null) {
                zds.putProperty("DEPEND_0", (Object)x);
            }
            if (y != null) {
                zds.putProperty("DEPEND_1", (Object)y);
            }
            this.model.setDataSet(chNum, label, (QDataSet)zds);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            this.model.waitUntilIdle();
        }
    }
}

